﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultSystemPlugin.Controls.Strategy;

namespace WinfootDefaultSystemPlugin.Controls
{
    public partial class EncryptionContextMenu : UserControl,IControl,ICorrespondenceOS
    {
         private EncryptionContextMenuController encryptionContextMenuController;

         public EncryptionContextMenu()
        {
            InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,                              
#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.google.co.jp/"));
                userHelp.Show();
            }
        }

        public void SetEncryptionContextMenuState(bool b)
        {
            checkBox1.Checked = b;
        }


        public int GetEncryptionContextMenuState()
        {
            if (checkBox1.Checked)
            {
                return 1;
            }
            return 0;
        }

        #region IControl メンバ

        public void Apply()
        {
            encryptionContextMenuController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return encryptionContextMenuController.BackUp();
        }

        #endregion

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        private void EncryptionContextMenu_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            encryptionContextMenuController = new EncryptionContextMenuController(this,
                                                                        (IEncryptionContextMenuStrategy)
                                                                        wfUtillity.
                                                                            GetCorrespondenceInstance
                                                                            (new List<ICorrespondenceOS>
                                                                                 {
                                                                                     new EncryptionContextMenuDefaultStrategy()
                                                                                 }));
            encryptionContextMenuController.Read();
        }
    }
}
